﻿// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License (Ms-PL).
// Please see http://go.microsoft.com/fwlink/?LinkID=131993 for details.
// All other rights reserved.

using System;
using System.Diagnostics.CodeAnalysis;
using NU = NUnit.Framework;

namespace Microsoft.Silverlight.Testing.UnitTesting.Metadata.NUnit
{
    /// <summary>
    /// Expected exception metadata.
    /// </summary>
    [SuppressMessage("Microsoft.Naming", "CA1711:IdentifiersShouldNotHaveIncorrectSuffix", Justification = "Standard unit test framework naming")]
    internal class ExpectedException : IExpectedException
    {
        /// <summary>
        /// Private constructor.
        /// </summary>
        private ExpectedException() { }

        /// <summary>
        /// Creates a new expected exception metadata wrapper.
        /// </summary>
        /// <param name="expectedExceptionAttribute">Attribute value.</param>
        public ExpectedException(NU.ExpectedExceptionAttribute expectedExceptionAttribute)
        {
            _exp = expectedExceptionAttribute;
            if (_exp == null)
            {
                throw new ArgumentNullException("expectedExceptionAttribute");
            }
        }

        /// <summary>
        /// The expected exception attribute.
        /// </summary>
        private NU.ExpectedExceptionAttribute _exp;

        /// <summary>
        /// Gets the type of the expected exception.
        /// </summary>
        public Type ExceptionType
        {
            get { return _exp.ExpectedException; }
        }

        /// <summary>
        /// Gets any message to include in a failure.
        /// </summary>
        public string Message
        {
            get { return _exp.UserMessage; }
        }
    }
}